/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.block.entity;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.items.IGrowableCrystal;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.core.definitions.AEItems;
import appeng.items.misc.CrystalSeedItem;
import appeng.me.helpers.MachineSource;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import io.github.projectet.ae2things.AE2Things;
import io.github.projectet.ae2things.inventory.CrystalGrowthSlot;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BECrystalGrowth
extends AENetworkPowerBlockEntity
implements IGridTickable,
IUpgradeableObject {
    private final AppEngInternalInventory inventory = new AppEngInternalInventory((InternalInventoryHost)this, 27);
    private final InternalInventory extInventory;
    private IUpgradeInventory upgrades;
    private boolean isWorking;
    private final Set<Integer> cachedGrowable = new HashSet<Integer>();

    public BECrystalGrowth(BlockPos pos, BlockState state) {
        super((BlockEntityType)AE2Things.CRYSTAL_GROWTH_BE.get(), pos, state);
        this.upgrades = UpgradeInventories.forMachine((ItemLike)((ItemLike)AE2Things.CRYSTAL_GROWTH.get()), (int)3, () -> ((BECrystalGrowth)this).saveChanges());
        FilteredInventory filter = new FilteredInventory();
        this.extInventory = new FilteredInternalInventory((InternalInventory)this.inventory, (IAEItemFilter)filter);
        this.getMainNode().setExposedOnSides(EnumSet.allOf(Direction.class)).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(1600.0);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, !this.hasWork() && this.inventory.isEmpty(), true);
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public boolean hasWork() {
        return this.hasFluixIngredients() || !this.cachedGrowable.isEmpty();
    }

    private boolean hasFluixIngredients() {
        boolean hasRedstone = this.inventory.simulateRemove(1, new ItemStack((ItemLike)Items.f_42451_), null).m_41613_() == 1;
        boolean hasChargedCertus = this.inventory.simulateRemove(1, new ItemStack((ItemLike)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED.m_5456_()), null).m_41613_() == 1;
        boolean hasQuartz = this.inventory.simulateRemove(1, new ItemStack((ItemLike)Items.f_42692_), null).m_41613_() == 1;
        return hasRedstone && hasChargedCertus && hasQuartz;
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.hasWork()) {
            int speedFactor = 1 + this.upgrades.getInstalledUpgrades((ItemLike)AEItems.SPEED_CARD);
            IEnergyService[] eg = new IEnergyService[1];
            BECrystalGrowth src = this;
            this.getMainNode().ifPresent(iGrid -> {
                eg[0] = iGrid.getEnergyService();
            });
            if (eg[0] == null) {
                return TickRateModulation.IDLE;
            }
            int powerConsumption = 10 * speedFactor;
            double powerThreshold = (double)powerConsumption - 0.01;
            double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            if (powerReq <= powerThreshold) {
                src = eg[0];
                powerReq = eg[0].extractAEPower((double)powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            }
            if (powerReq > powerThreshold) {
                if (!this.isWorking()) {
                    this.isWorking = true;
                    this.markForUpdate();
                }
            } else {
                if (this.isWorking()) {
                    this.isWorking = false;
                    this.markForUpdate();
                }
                return TickRateModulation.IDLE;
            }
            src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
            for (Integer slot : this.cachedGrowable.stream().toList()) {
                ItemStack crystal = this.inventory.getStackInSlot(slot.intValue());
                if (!(crystal.m_41720_() instanceof IGrowableCrystal)) {
                    this.cachedGrowable.remove(slot);
                    continue;
                }
                this.inventory.setItemDirect(slot.intValue(), this.triggerGrowth(crystal, 20, speedFactor));
                this.saveChanges();
            }
            if (this.hasFluixIngredients() && this.inventory.simulateAdd(new ItemStack((ItemLike)AEItems.FLUIX_DUST, 2)).m_41619_()) {
                this.inventory.removeItems(1, new ItemStack((ItemLike)Items.f_42451_), null).m_41613_();
                this.inventory.removeItems(1, new ItemStack((ItemLike)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED.m_5456_()), null).m_41613_();
                this.inventory.removeItems(1, new ItemStack((ItemLike)Items.f_42692_), null).m_41613_();
                this.inventory.addItems(new ItemStack((ItemLike)AEItems.FLUIX_DUST, 2));
                this.saveChanges();
            }
            if (this.cachedGrowable.isEmpty() && !this.hasFluixIngredients()) {
                this.isWorking = false;
                this.markForUpdate();
            }
        }
        if (!this.inventory.isEmpty()) {
            MEStorage gridStorage = this.getMainNode().getGrid().getStorageService().getInventory();
            for (ItemStack stack : this.inventory) {
                if (stack.equals(ItemStack.f_41583_) || stack.m_41720_().equals(Items.f_41852_) || FilteredInventory.canTransfer(stack.m_41720_())) continue;
                AEItemKey item = AEItemKey.of((ItemStack)stack);
                long inserted = gridStorage.insert((AEKey)item, (long)stack.m_41613_(), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)this));
                stack.m_41774_((int)inserted);
            }
        }
        return this.hasWork() ? TickRateModulation.URGENT : (!this.inventory.isEmpty() ? TickRateModulation.SLOWER : TickRateModulation.SLEEP);
    }

    public void setOrientation(Direction inForward, Direction inUp) {
        this.setPowerSides(EnumSet.allOf(Direction.class));
    }

    public void onReady() {
        this.getMainNode().setExposedOnSides(EnumSet.allOf(Direction.class));
        super.onReady();
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.setItemDirect(i, data.m_130267_());
        }
        return c;
    }

    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        for (int i = 0; i < this.inventory.size(); ++i) {
            data.m_130055_(this.inventory.getStackInSlot(i));
        }
    }

    @Nullable
    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)ISegmentedInventory.STORAGE)) {
            return this.getInternalInventory();
        }
        if (id.equals((Object)ISegmentedInventory.UPGRADES)) {
            return this.upgrades;
        }
        return super.getSubInventory(id);
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.upgrades.writeToNBT(data, "upgrades");
        data.m_128408_("cache", this.cachedGrowable.stream().toList());
        data.m_128379_("working", this.isWorking);
    }

    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.upgrades.readFromNBT(data, "upgrades");
        this.cachedGrowable.addAll(Arrays.stream(data.m_128465_("cache")).boxed().toList());
        this.isWorking = data.m_128471_("working");
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack upgrade : this.upgrades) {
            drops.add(upgrade);
        }
    }

    public InternalInventory getInternalInventory() {
        return this.inventory;
    }

    public InternalInventory getExposedInventoryForSide(Direction side) {
        return this.extInventory;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv.getStackInSlot(slot).m_41720_() instanceof IGrowableCrystal) {
            this.cachedGrowable.add(slot);
        }
        this.markForUpdate();
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public ItemStack triggerGrowth(ItemStack seedItem, int ticks, int multiplier) {
        Item item = seedItem.m_41720_();
        if (item instanceof CrystalSeedItem) {
            CrystalSeedItem crystalSeedItem = (CrystalSeedItem)item;
            int growthTicks = CrystalSeedItem.getGrowthTicks((ItemStack)seedItem) + ticks * multiplier;
            CrystalSeedItem.setGrowthTicks((ItemStack)seedItem, (int)growthTicks);
            if (CrystalSeedItem.getGrowthTicks((ItemStack)seedItem) >= 24000) {
                return crystalSeedItem.triggerGrowth(seedItem);
            }
        }
        return seedItem;
    }

    public class FilteredInventory
    implements IAEItemFilter {
        public static boolean canTransfer(Item item) {
            return CrystalGrowthSlot.validItems.contains(item) || item instanceof CrystalSeedItem;
        }

        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return !FilteredInventory.canTransfer(inv.getStackInSlot(slot).m_41720_());
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return FilteredInventory.canTransfer(stack.m_41720_());
        }
    }
}

